* Constants for type libary: c:\winnt\system32\mqoa.dll
* Microsoft Message Queue Object Library

* MQCALG Enum
* Enumerates various hashing and encryption algorithms.
#DEFINE MQMSG_CALG_MD2    32769
#DEFINE MQMSG_CALG_MD4    32770
#DEFINE MQMSG_CALG_MD5    32771
#DEFINE MQMSG_CALG_SHA    32772
#DEFINE MQMSG_CALG_MAC    32773
#DEFINE MQMSG_CALG_RSA_SIGN    9216
#DEFINE MQMSG_CALG_DSS_SIGN    8704
#DEFINE MQMSG_CALG_RSA_KEYX    41984
#DEFINE MQMSG_CALG_DES    26113
#DEFINE MQMSG_CALG_RC2    26114
#DEFINE MQMSG_CALG_RC4    26625
#DEFINE MQMSG_CALG_SEAL    26626
  
* MQTRANSACTION Enum
* Enumerates the transaction options when sending and receiving a message.
#DEFINE MQ_NO_TRANSACTION    0
#DEFINE MQ_MTS_TRANSACTION    1
#DEFINE MQ_XA_TRANSACTION    2
#DEFINE MQ_SINGLE_MESSAGE    3
  
* RELOPS Enum
* Enumerates the relational operators for a query.
#DEFINE REL_NOP    0
#DEFINE REL_EQ    1
#DEFINE REL_NEQ    2
#DEFINE REL_LT    3
#DEFINE REL_GT    4
#DEFINE REL_LE    5
#DEFINE REL_GE    6
  
* MQMSGCURSOR Enum
* Enumerates the cursor operations when synchronously or asynchronously peeking at or retrieving a message.
#DEFINE MQMSG_FIRST    0
#DEFINE MQMSG_CURRENT    1
#DEFINE MQMSG_NEXT    2
  
* MQMSGCLASS Enum
* Enumerates the classes of a message.
#DEFINE MQMSG_CLASS_NORMAL    0
#DEFINE MQMSG_CLASS_REPORT    1
#DEFINE MQMSG_CLASS_ACK_REACH_QUEUE    2
#DEFINE MQMSG_CLASS_ACK_RECEIVE    16384
#DEFINE MQMSG_CLASS_NACK_BAD_DST_Q    32768
#DEFINE MQMSG_CLASS_NACK_PURGED    32769
#DEFINE MQMSG_CLASS_NACK_REACH_QUEUE_TIMEOUT    32770
#DEFINE MQMSG_CLASS_NACK_Q_EXCEED_QUOTA    32771
#DEFINE MQMSG_CLASS_NACK_ACCESS_DENIED    32772
#DEFINE MQMSG_CLASS_NACK_HOP_COUNT_EXCEEDED    32773
#DEFINE MQMSG_CLASS_NACK_BAD_SIGNATURE    32774
#DEFINE MQMSG_CLASS_NACK_BAD_ENCRYPTION    32775
#DEFINE MQMSG_CLASS_NACK_COULD_NOT_ENCRYPT    32776
#DEFINE MQMSG_CLASS_NACK_NOT_TRANSACTIONAL_Q    32777
#DEFINE MQMSG_CLASS_NACK_NOT_TRANSACTIONAL_MSG    32778
#DEFINE MQMSG_CLASS_NACK_Q_DELETED    49152
#DEFINE MQMSG_CLASS_NACK_Q_PURGED    49153
#DEFINE MQMSG_CLASS_NACK_RECEIVE_TIMEOUT    49154
  
* MQMSGDELIVERY Enum
* Enumerates the delivery modes of a message.
#DEFINE MQMSG_DELIVERY_EXPRESS    0
#DEFINE MQMSG_DELIVERY_RECOVERABLE    1
  
* MQMSGACKNOWLEDGEMENT Enum
* Enumerates the acknowledgement modes for a message.
#DEFINE MQMSG_ACKNOWLEDGMENT_NONE    0
#DEFINE MQMSG_ACKNOWLEDGMENT_POS_ARRIVAL    1
#DEFINE MQMSG_ACKNOWLEDGMENT_POS_RECEIVE    2
#DEFINE MQMSG_ACKNOWLEDGMENT_NEG_ARRIVAL    4
#DEFINE MQMSG_ACKNOWLEDGMENT_NEG_RECEIVE    8
#DEFINE MQMSG_ACKNOWLEDGMENT_NACK_REACH_QUEUE    4
#DEFINE MQMSG_ACKNOWLEDGMENT_FULL_REACH_QUEUE    5
#DEFINE MQMSG_ACKNOWLEDGMENT_NACK_RECEIVE    12
#DEFINE MQMSG_ACKNOWLEDGMENT_FULL_RECEIVE    14
  
* MQMSGJOURNAL Enum
* Enumerates the journaling for a message.
#DEFINE MQMSG_JOURNAL_NONE    0
#DEFINE MQMSG_DEADLETTER    1
#DEFINE MQMSG_JOURNAL    2
  
* MQMSGTRACE Enum
* Enumerates the tracing options for a message.
#DEFINE MQMSG_TRACE_NONE    0
#DEFINE MQMSG_SEND_ROUTE_TO_REPORT_QUEUE    1
  
* MQMSGSENDERIDTYPE Enum
* Enumerates the sender identifier types for a message.
#DEFINE MQMSG_SENDERID_TYPE_NONE    0
#DEFINE MQMSG_SENDERID_TYPE_SID    1
  
* MQMSGPRIVLEVEL Enum
* Enumerates the privacy levels for a message.
#DEFINE MQMSG_PRIV_LEVEL_NONE    0
#DEFINE MQMSG_PRIV_LEVEL_BODY    1
  
* MQMSGAUTHLEVEL Enum
* Enumerates the authorization levels for a message.
#DEFINE MQMSG_AUTH_LEVEL_NONE    0
#DEFINE MQMSG_AUTH_LEVEL_ALWAYS    1
  
* MQMSGIDSIZE Enum
* Enumerates message identification property sizes.
#DEFINE MQMSG_MSGID_SIZE    20
#DEFINE MQMSG_CORRELATIONID_SIZE    20
  
* MQMSGMAX Enum
* Enumerates the maximum length for the message label.
#DEFINE MQ_MAX_MSG_LABEL_LEN    249
  
* MQSHARE Enum
* Enumerates the sharing modes for an open queue.
#DEFINE MQ_DENY_NONE    0
#DEFINE MQ_DENY_RECEIVE_SHARE    1
  
* MQACCESS Enum
* Enumerates the access (send, peek, receive) modes for an open queue.
#DEFINE MQ_RECEIVE_ACCESS    1
#DEFINE MQ_SEND_ACCESS    2
#DEFINE MQ_PEEK_ACCESS    32
  
* MQJOURNAL Enum
* Enumerates the journaling modes for a queue.
#DEFINE MQ_JOURNAL_NONE    0
#DEFINE MQ_JOURNAL    1
  
* MQTRANSACTIONAL Enum
* Enumerates the transactional modes for a queue.
#DEFINE MQ_TRANSACTIONAL_NONE    0
#DEFINE MQ_TRANSACTIONAL    1
  
* MQAUTHENTICATE Enum
* Enumerates the authentication modes for a queue.
#DEFINE MQ_AUTHENTICATE_NONE    0
#DEFINE MQ_AUTHENTICATE    1
  
* MQPRIVLEVEL Enum
* Enumerates the privacy levels for a queue.
#DEFINE MQ_PRIV_LEVEL_NONE    0
#DEFINE MQ_PRIV_LEVEL_OPTIONAL    1
#DEFINE MQ_PRIV_LEVEL_BODY    2
  
* MQPRIORITY Enum
* Enumerates the minimum and maximum queue priorities.
#DEFINE MQ_MIN_PRIORITY    0
#DEFINE MQ_MAX_PRIORITY    7
  
* MQMAX Enum
* Enumerates the maximum length for a queue label and pathname.
#DEFINE MQ_MAX_Q_NAME_LEN    124
#DEFINE MQ_MAX_Q_LABEL_LEN    124
  
* MQDEFAULT Enum
* Enumerates the default values for message and queue properties.
#DEFINE DEFAULT_M_PRIORITY    3
#DEFINE DEFAULT_M_DELIVERY    0
#DEFINE DEFAULT_M_ACKNOWLEDGE    0
#DEFINE DEFAULT_M_JOURNAL    0
#DEFINE DEFAULT_M_APPSPECIFIC    0
#DEFINE DEFAULT_M_PRIV_LEVEL    0
#DEFINE DEFAULT_M_AUTH_LEVEL    0
#DEFINE DEFAULT_M_SENDERID_TYPE    1
#DEFINE DEFAULT_Q_JOURNAL    0
#DEFINE DEFAULT_Q_BASEPRIORITY    0
#DEFINE DEFAULT_Q_QUOTA    -1
#DEFINE DEFAULT_Q_JOURNAL_QUOTA    -1
#DEFINE DEFAULT_Q_TRANSACTION    0
#DEFINE DEFAULT_Q_AUTHENTICATE    0
#DEFINE DEFAULT_Q_PRIV_LEVEL    1
  
* MQERROR Enum
* Enumerates all MSMQ errors.
#DEFINE MQ_ERROR    -1072824319
#DEFINE MQ_ERROR_PROPERTY    -1072824318
#DEFINE MQ_ERROR_QUEUE_NOT_FOUND    -1072824317
#DEFINE MQ_ERROR_QUEUE_EXISTS    -1072824315
#DEFINE MQ_ERROR_INVALID_PARAMETER    -1072824314
#DEFINE MQ_ERROR_INVALID_HANDLE    -1072824313
#DEFINE MQ_ERROR_OPERATION_CANCELLED    -1072824312
#DEFINE MQ_ERROR_SHARING_VIOLATION    -1072824311
#DEFINE MQ_ERROR_SERVICE_NOT_AVAILABLE    -1072824309
#DEFINE MQ_ERROR_MACHINE_NOT_FOUND    -1072824307
#DEFINE MQ_ERROR_ILLEGAL_SORT    -1072824304
#DEFINE MQ_ERROR_ILLEGAL_USER    -1072824303
#DEFINE MQ_ERROR_UNSUPPORTED_DBMS    -1072824302
#DEFINE MQ_ERROR_NO_DS    -1072824301
#DEFINE MQ_ERROR_ILLEGAL_QUEUE_PATHNAME    -1072824300
#DEFINE MQ_ERROR_ILLEGAL_PROPERTY_VALUE    -1072824296
#DEFINE MQ_ERROR_ILLEGAL_PROPERTY_VT    -1072824295
#DEFINE MQ_ERROR_BUFFER_OVERFLOW    -1072824294
#DEFINE MQ_ERROR_IO_TIMEOUT    -1072824293
#DEFINE MQ_ERROR_ILLEGAL_CURSOR_ACTION    -1072824292
#DEFINE MQ_ERROR_MESSAGE_ALREADY_RECEIVED    -1072824291
#DEFINE MQ_ERROR_ILLEGAL_FORMATNAME    -1072824290
#DEFINE MQ_ERROR_FORMATNAME_BUFFER_TOO_SMALL    -1072824289
#DEFINE MQ_ERROR_UNSUPPORTED_FORMATNAME_OPERATION    -1072824288
#DEFINE MQ_ERROR_ILLEGAL_SECURITY_DESCRIPTOR    -1072824287
#DEFINE MQ_ERROR_SENDERID_BUFFER_TOO_SMALL    -1072824286
#DEFINE MQ_ERROR_SECURITY_DESCRIPTOR_TOO_SMALL    -1072824285
#DEFINE MQ_ERROR_CANNOT_IMPERSONATE_CLIENT    -1072824284
#DEFINE MQ_ERROR_ACCESS_DENIED    -1072824283
#DEFINE MQ_ERROR_PRIVILEGE_NOT_HELD    -1072824282
#DEFINE MQ_ERROR_INSUFFICIENT_RESOURCES    -1072824281
#DEFINE MQ_ERROR_USER_BUFFER_TOO_SMALL    -1072824280
#DEFINE MQ_ERROR_MESSAGE_STORAGE_FAILED    -1072824278
#DEFINE MQ_ERROR_SENDER_CERT_BUFFER_TOO_SMALL    -1072824277
#DEFINE MQ_ERROR_INVALID_CERTIFICATE    -1072824276
#DEFINE MQ_ERROR_CORRUPTED_INTERNAL_CERTIFICATE    -1072824275
#DEFINE MQ_ERROR_INTERNAL_USER_CERT_EXIST    -1072824274
#DEFINE MQ_ERROR_NO_INTERNAL_USER_CERT    -1072824273
#DEFINE MQ_ERROR_CORRUPTED_SECURITY_DATA    -1072824272
#DEFINE MQ_ERROR_CORRUPTED_PERSONAL_CERT_STORE    -1072824271
#DEFINE MQ_ERROR_COMPUTER_DOES_NOT_SUPPORT_ENCRYPTION    -1072824269
#DEFINE MQ_ERROR_BAD_SECURITY_CONTEXT    -1072824267
#DEFINE MQ_ERROR_COULD_NOT_GET_USER_SID    -1072824266
#DEFINE MQ_ERROR_COULD_NOT_GET_ACCOUNT_INFO    -1072824265
#DEFINE MQ_ERROR_ILLEGAL_MQCOLUMNS    -1072824264
#DEFINE MQ_ERROR_ILLEGAL_PROPID    -1072824263
#DEFINE MQ_ERROR_ILLEGAL_RELATION    -1072824262
#DEFINE MQ_ERROR_ILLEGAL_PROPERTY_SIZE    -1072824261
#DEFINE MQ_ERROR_ILLEGAL_RESTRICTION_PROPID    -1072824260
#DEFINE MQ_ERROR_ILLEGAL_MQQUEUEPROPS    -1072824259
#DEFINE MQ_ERROR_PROPERTY_NOTALLOWED    -1072824258
#DEFINE MQ_ERROR_INSUFFICIENT_PROPERTIES    -1072824257
#DEFINE MQ_ERROR_MACHINE_EXISTS    -1072824256
#DEFINE MQ_ERROR_ILLEGAL_MQQMPROPS    -1072824255
#DEFINE MQ_ERROR_DS_IS_FULL    -1072824254
#DEFINE MQ_ERROR_DS_ERROR    -1072824253
#DEFINE MQ_ERROR_INVALID_OWNER    -1072824252
#DEFINE MQ_ERROR_UNSUPPORTED_ACCESS_MODE    -1072824251
#DEFINE MQ_ERROR_RESULT_BUFFER_TOO_SMALL    -1072824250
#DEFINE MQ_ERROR_DELETE_CN_IN_USE    -1072824248
#DEFINE MQ_ERROR_NO_RESPONSE_FROM_OBJECT_SERVER    -1072824247
#DEFINE MQ_ERROR_OBJECT_SERVER_NOT_AVAILABLE    -1072824246
#DEFINE MQ_ERROR_QUEUE_NOT_AVAILABLE    -1072824245
#DEFINE MQ_ERROR_DTC_CONNECT    -1072824244
#DEFINE MQ_ERROR_TRANSACTION_IMPORT    -1072824242
#DEFINE MQ_ERROR_TRANSACTION_USAGE    -1072824240
#DEFINE MQ_ERROR_TRANSACTION_SEQUENCE    -1072824239
#DEFINE MQ_ERROR_MISSING_CONNECTOR_TYPE    -1072824235
#DEFINE MQ_ERROR_STALE_HANDLE    -1072824234
#DEFINE MQ_ERROR_TRANSACTION_ENLIST    -1072824232
#DEFINE MQ_ERROR_QUEUE_DELETED    -1072824230
#DEFINE MQ_ERROR_ILLEGAL_CONTEXT    -1072824229
#DEFINE MQ_ERROR_ILLEGAL_SORT_PROPID    -1072824228
#DEFINE MQ_ERROR_LABEL_TOO_LONG    -1072824227
#DEFINE MQ_ERROR_LABEL_BUFFER_TOO_SMALL    -1072824226
#DEFINE MQ_ERROR_MQIS_SERVER_EMPTY    -1072824225
#DEFINE MQ_ERROR_MQIS_READONLY_MODE    -1072824224
#DEFINE MQ_ERROR_SYMM_KEY_BUFFER_TOO_SMALL    -1072824223
#DEFINE MQ_ERROR_SIGNATURE_BUFFER_TOO_SMALL    -1072824222
#DEFINE MQ_ERROR_PROV_NAME_BUFFER_TOO_SMALL    -1072824221
#DEFINE MQ_ERROR_ILLEGAL_OPERATION    -1072824220
#DEFINE MQ_ERROR_WRITE_NOT_ALLOWED    -1072824219
  
* MQWARNING Enum
* Enumerates all MSMQ warnings.
#DEFINE MQ_INFORMATION_PROPERTY    1074659329
#DEFINE MQ_INFORMATION_ILLEGAL_PROPERTY    1074659330
#DEFINE MQ_INFORMATION_PROPERTY_IGNORED    1074659331
#DEFINE MQ_INFORMATION_UNSUPPORTED_PROPERTY    1074659332
#DEFINE MQ_INFORMATION_DUPLICATE_PROPERTY    1074659333
#DEFINE MQ_INFORMATION_OPERATION_PENDING    1074659334
#DEFINE MQ_INFORMATION_FORMATNAME_BUFFER_TOO_SMALL    1074659337
  